import pyxel
from liste_tuiles import *

'''
Il y a 4 possibilités pour les tuiles :
- le personnage peut passer à travers : valeur 0
- le personnage peut monter dessus : valeur 1
- le personnage peut monter dessus mais également les détruire : valeur 2
- le personnage peut passer à travers mais elles sont alors censées disparaître (pensez aux bonus) : valeur 3

Compte-tenu de l'ordre dans lequel les tuiles sont stockées, qui est le même que celui dans lequel vous pouvez les voir dans l'image "sortie.png"
(de gauche à droite et de haut en bas), les valeurs successives à donner sont :
011122121110011301010112200012110000
'''

pyxel.init(256,256)
pyxel.load("alexkid.pyxres")
cote = 1 + int(len(tuiles)**0.5)
pos = {"x" : 18,
       "y" : 111,
       "w" : 16,
       "h" : 24,
       "vx" : 0,
       "vy" : 0,
       "orientation" : False,
       "accr" : False,
       "saut" : False,
       "cg" : False,
       "cd" : False,
       "ch" : False,
       "cb" : False,
       "coup" : False}

def update():
    if pyxel.btnp(pyxel.KEY_Q):
        pyxel.quit()
    if pyxel.btn(pyxel.KEY_DOWN):
        pos["y"] += 1
    if pyxel.btn(pyxel.KEY_UP):
        pos["y"] -= 1
    if pyxel.btn(pyxel.KEY_LEFT):
        pos["x"] -= 1
    if pyxel.btn(pyxel.KEY_RIGHT):
        pos["x"] += 1
    
    # déplacement de la caméra de façon à ce que personnage soit à peu près centré
    pyxel.camera(max(0,pos["x"]-128),max(0,pos["y"]-128))
    
    # tests des collisions
    for i in range(len(tuiles)):
        for j in tuiles[i]:
            a = contact([pos["x"],pos["y"],16,24],[j[0],j[1],16,16])
            if a > 0:
                print(f"contact {a} avec la tuile {j} de type {i}")
    

def draw():
    #effacement du terrain
    pyxel.cls(0)
    
    # dessin du niveau
    for i in range(len(tuiles)):
        for j in tuiles[i]:
            pyxel.blt(j[0], j[1], 2, 16*(i%cote), 16*(i//cote), 16, 16)
    
    # dessin du personnage
    pyxel.blt(pos["x"]-16, pos["y"]-24,0,16,0,16,24,7)
    

def contact(obj_1, obj_2):
    """
    prend en entrée 2 hitbox [x, y, largeur, hauteur] et retourne si obj1 est en contact avec obj2 et sur quelle face :
    0 : pas de contact
    1 : contact sous obj1 
    2 : contact haut-dessus obj1
    3 : contact droite obj1
    4 : contact gauche obj1
    Avantage : si on veut juste savoir si contact il y a, un test logique suffit
    Méthode : elle définit un contour de 1 pixel sur obj_1 et un contour de 4 pixel sur obj_2 et utilise la méthode des recouvrements de rectangles
    définis dans la fonction contact2 pour savoir si ces contours se recouvrent
    """
    if contact2([obj_1[0], obj_1[1], obj_1[2], 1], [obj_2[0], obj_2[1] + obj_2[3] - 4, obj_2[2] , 4]):
        return 2
    if contact2([obj_1[0], obj_1[1] + obj_1[3], obj_1[2], 1], [obj_2[0], obj_2[1], obj_2[2], 4]):
        return 1
    if contact2([obj_1[0] + obj_1[2], obj_1[1], 1, obj_1[3]], [obj_2[0], obj_2[1], 1, obj_2[3]]):
        return 3
    if contact2([obj_1[0], obj_1[1], 1, obj_1[3]], [obj_2[0] + obj_2[2] - 2, obj_2[1], 1, obj_2[3]]):
        return 4
    return 0

def contact2(A, B):
    #print(A,B)
    """
    Indique si 2 rectangles A et B définis par [x_haut, y_haut, largeur, hauteur] se recouvrent
    """
    maxgauche = max(A[0], B[0])
    mindroit = min(A[0] + A[2], B[0] + B[2])
    if maxgauche < mindroit :
        maxbas = max(A[1], B[1])
        minhaut = min(A[1] + A[3], B[1] + B[3])
        if maxbas < minhaut :
            return True
    return False


pyxel.run(update, draw)