from PIL import Image
import numpy as np
# J'ouvre l'image et la stocke dans la variable mon_image
mon_image = Image.open("schtroumpf.jpg")
# je transforme l'image en tableau
mon_tableau = np.array(mon_image)
# j'affiche l'image stockée dans le tableau
Image.fromarray(mon_tableau)

def niveaux_gris(tableau):
    hauteur, largeur = len(tableau), len(tableau[0])
    nouvelle_image = Image.new('L', (largeur, hauteur))
    nouveau_tableau = np.array(nouvelle_image)
    for i in range(largeur):
        for j in range(hauteur):
            R, V, B = tableau[j][i]
            R = int(R)
            V = int(V)
            B = int(B)
            gris = (R + V + B) // 3
            nouveau_tableau[j][i] = gris
    return nouveau_tableau

tableau_gris = niveaux_gris(mon_tableau)
Image.fromarray(tableau_gris).show()

def redimensionner(tableau, facteur):
    hauteur, largeur = len(tableau), len(tableau[0])
    nouvelle_image = Image.new('L', ( largeur // facteur,
                                     hauteur // facteur )) # à compléter
    nouveau_tableau = np.array(nouvelle_image)
    
    for i in range(0, facteur * (hauteur//facteur), facteur):
        for j in range(0, facteur * (largeur//facteur), facteur) :
            somme = 0
            for p in range(facteur):
                for q in range(facteur):
                    g = int(tableau[i + q][j + p])
                    somme = somme + g
            
            moyenne = somme // (facteur ** 2)
            nouveau_tableau[i // facteur][j // facteur] = moyenne
            
            
    
    return nouveau_tableau

tableau_redim = redimensionner(tableau_gris, 8)
Image.fromarray(tableau_redim).show() 